/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import jtbcore.socket.SSLSocketFactory;
import jtbcore.util.FileUtil;

public class RawHttpRequest {
    protected String hostname;
    protected Integer port;
    protected boolean secure = false;

    public RawHttpRequest(String hostname, Integer port) {
        this.hostname = hostname;
        this.port = port;
    }

    public void request(String data, File outputFile) throws UnknownHostException, IOException, UnrecoverableKeyException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Socket s = null;
        s = this.secure ? SSLSocketFactory.createConnection(this.hostname, this.port) : new Socket(this.hostname, (int)this.port);
        BufferedOutputStream os = new BufferedOutputStream(s.getOutputStream());
        BufferedInputStream is = new BufferedInputStream(s.getInputStream());
        ((OutputStream)os).write(data.getBytes());
        ((OutputStream)os).flush();
        s.shutdownOutput();
        FileUtil.inputStream2File((InputStream)is, outputFile);
        s.close();
    }

    public byte[] request2bytes(String data) throws UnknownHostException, IOException, UnrecoverableKeyException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        int len;
        Socket s = null;
        s = this.secure ? SSLSocketFactory.createConnection(this.hostname, this.port) : new Socket(this.hostname, (int)this.port);
        BufferedOutputStream os = new BufferedOutputStream(s.getOutputStream());
        BufferedInputStream is = new BufferedInputStream(s.getInputStream());
        ((OutputStream)os).write(data.getBytes());
        ((OutputStream)os).flush();
        s.shutdownOutput();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = ((InputStream)is).read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        s.close();
        baos.close();
        return baos.toByteArray();
    }

    public byte[] request2bytes(byte[] data) throws UnknownHostException, IOException, UnrecoverableKeyException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        int len;
        Socket s = null;
        s = this.secure ? SSLSocketFactory.createConnection(this.hostname, this.port) : new Socket(this.hostname, (int)this.port);
        OutputStream os = s.getOutputStream();
        InputStream is = s.getInputStream();
        os.write(data);
        os.flush();
        s.shutdownOutput();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = is.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        s.close();
        baos.close();
        return baos.toByteArray();
    }

    public static void main(String[] args) {
        try {
            String data = FileUtil.file2string("/home/timvw/tmp/req");
            RawHttpRequest r = new RawHttpRequest("127.0.0.1", 49365);
            byte[] buf = r.request2bytes(data);
            System.out.println("Result: ");
            System.out.write(buf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

